#!/bin/bash

export PATH=/usr/local/bin:/opt/homebrew/bin:$PATH

url="$KMPARAM_URL"
selector="$KMPARAM_Selector"
stype="$KMPARAM_Selector_Type"

if [[ -z "$url" || -z "$selector" ]]; then
    echo "Error: URL or Selector parameter is empty."
    exit 1
fi

if [[ "$stype" == "CSS" ]]; then
    if ! command -v pup &> /dev/null; then
        echo "Error: 'pup' not found. Install with: brew install pup"
        exit 1
    fi
    curl -sL "$url" | pup "$selector" text{}
elif [[ "$stype" == "XPath" ]]; then
    curl -sL "$url" | xmllint --html --xpath "$selector" - 2>/dev/null
else
    echo "Error: Invalid Selector Type."
    exit 1
fi
